/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.classes.models.circleVisibility;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.olvid.keycloak.classes.models.circleVisibility.CircleVisibilityModel;
import io.olvid.keycloak.classes.models.circleVisibility.CirclesVisibilityRulesModel;
import io.olvid.keycloak.classes.models.circleVisibility.OlvidCircleVisibilityRulesListByVisibilityModel;
import io.olvid.keycloak.classes.models.users.CustomUserBasicModel;
import io.olvid.keycloak.jpa.OlvidCircleVisibility;
import io.olvid.keycloak.jpa.OlvidCircleVisibilityRules;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlvidCircleVisibilityRulesListModel {
    protected static final org.jboss.logging.Logger logger = org.jboss.logging.Logger.getLogger(OlvidCircleVisibilityRulesListModel.class);
    private static final Logger log = LoggerFactory.getLogger(OlvidCircleVisibilityRulesListModel.class);
    @JsonProperty(value="circleVisibilityRulesList")
    public List<CirclesVisibilityRulesModel> circleVisibilityRulesList;
    @JsonProperty(value="circleVisibilityRulesRowList")
    public List circleVisibilityRulesRowList;
    @JsonProperty(value="circleVisibilityRulesUsersRowList")
    public List circleVisibilityRulesUsersRowList;
    @JsonProperty(value="from")
    public Map<String, List<CirclesVisibilityRulesModel>> from;
    @JsonProperty(value="to")
    public Map<String, List<CirclesVisibilityRulesModel>> to;

    public List getCircleVisibilityRulesRowList() {
        return this.circleVisibilityRulesRowList;
    }

    public void setCircleVisibilityRulesRowList(List circleVisibilityRulesRowList) {
        this.circleVisibilityRulesRowList = circleVisibilityRulesRowList;
    }

    public List<CirclesVisibilityRulesModel> getCircleVisibilityRulesList() {
        return this.circleVisibilityRulesList;
    }

    public void setCircleVisibilityRulesList(List<CirclesVisibilityRulesModel> circleVisibilityRulesList) {
        this.circleVisibilityRulesList = circleVisibilityRulesList;
    }

    public Map<String, List<CirclesVisibilityRulesModel>> getFrom() {
        return this.from;
    }

    public void setFrom(Map<String, List<CirclesVisibilityRulesModel>> from) {
        this.from = from;
    }

    public Map<String, List<CirclesVisibilityRulesModel>> getTo() {
        return this.to;
    }

    public void setTo(Map<String, List<CirclesVisibilityRulesModel>> to) {
        this.to = to;
    }

    public List getCircleVisibilityRulesUsersRowList() {
        return this.circleVisibilityRulesUsersRowList;
    }

    public void setCircleVisibilityRulesUsersRowList(List circleVisibilityRulesUsersRowList) {
        this.circleVisibilityRulesUsersRowList = circleVisibilityRulesUsersRowList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlvidCircleVisibilityRulesListModel that = (OlvidCircleVisibilityRulesListModel)o;
        return Objects.equals(this.circleVisibilityRulesList, that.circleVisibilityRulesList) && Objects.equals(this.circleVisibilityRulesRowList, that.circleVisibilityRulesRowList) && Objects.equals(this.circleVisibilityRulesUsersRowList, that.circleVisibilityRulesUsersRowList) && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
    }

    public int hashCode() {
        return Objects.hash(this.circleVisibilityRulesList, this.circleVisibilityRulesRowList, this.circleVisibilityRulesUsersRowList, this.from, this.to);
    }

    public String toString() {
        return "OlvidCircleVisibilityRulesListModel{circleVisibilityRulesList=" + String.valueOf(this.circleVisibilityRulesList) + ", circleVisibilityRulesRowList=" + String.valueOf(this.circleVisibilityRulesRowList) + ", circleVisibilityRulesUsersRowList=" + String.valueOf(this.circleVisibilityRulesUsersRowList) + ", from=" + String.valueOf(this.from) + ", to=" + String.valueOf(this.to) + "}";
    }

    public OlvidCircleVisibilityRulesListModel newOlvidCircleVisibilityRulesListModel(EntityManager em, KeycloakSession session, RealmModel realmModel, List<OlvidCircleVisibilityRules> rules, String id, Boolean isWithMembers) {
        OlvidCircleVisibilityRulesListModel olvidCircleVisibilityRulesListModel = new OlvidCircleVisibilityRulesListModel();
        ArrayList<CirclesVisibilityRulesModel> arrayCircleVisibilityRulesList = new ArrayList<CirclesVisibilityRulesModel>();
        rules.forEach(rule -> {
            CirclesVisibilityRulesModel groupsVisibilityRules = new CirclesVisibilityRulesModel();
            groupsVisibilityRules.setVisibilityRule(rule.getVisibility());
            CircleVisibilityModel customVisbilityRulesModelFrom = new CircleVisibilityModel();
            OlvidCircleVisibility retFrom = new OlvidCircleVisibility();
            if (rule.getCircleVisibilityId1From() != null) {
                if (!rule.getCircleVisibilityId1From().contains("default")) {
                    TypedQuery queryFrom = em.createNamedQuery("OlvidCircleVisibility.getById", OlvidCircleVisibility.class);
                    queryFrom.setParameter("realmId", (Object)realmModel.getId());
                    queryFrom.setParameter("id", (Object)rule.getCircleVisibilityId1From());
                    try {
                        retFrom = (OlvidCircleVisibility)queryFrom.getSingleResult();
                    }
                    catch (NoResultException noResultException) {}
                } else {
                    retFrom.setId("default");
                    retFrom.setName("Default Circle");
                    retFrom.setDescription("All users not assigned to any other Circle");
                    retFrom.setRealmId(rule.getRealmId());
                }
            } else if (rule.getCircleVisibilityId2To() != null) {
                retFrom.setId("default");
                retFrom.setName("Default Circle");
                retFrom.setDescription("All users not assigned to any other Circle");
                retFrom.setRealmId(rule.getRealmId());
            } else {
                retFrom.setId("defaultCircleBetweenMembers");
                retFrom.setName("Default Circle");
                retFrom.setDescription("All users not assigned to any other Circle");
                retFrom.setRealmId(rule.getRealmId());
            }
            customVisbilityRulesModelFrom.setId(retFrom.getId());
            customVisbilityRulesModelFrom.setName(retFrom.getName());
            customVisbilityRulesModelFrom.setDescription(retFrom.getDescription());
            groupsVisibilityRules.setFrom(customVisbilityRulesModelFrom);
            CircleVisibilityModel customVisbilityRulesModelTo = new CircleVisibilityModel();
            OlvidCircleVisibility retTo = new OlvidCircleVisibility();
            if (rule.getCircleVisibilityId2To() != null) {
                if (!rule.getCircleVisibilityId2To().contains("default")) {
                    TypedQuery queryTo = em.createNamedQuery("OlvidCircleVisibility.getById", OlvidCircleVisibility.class);
                    queryTo.setParameter("realmId", (Object)realmModel.getId());
                    queryTo.setParameter("id", (Object)rule.getCircleVisibilityId2To());
                    try {
                        retTo = (OlvidCircleVisibility)queryTo.getSingleResult();
                    }
                    catch (NoResultException noResultException) {}
                } else {
                    retTo.setId("default");
                    retTo.setName("Default Circle");
                    retTo.setDescription("All users not assigned to any other Circle");
                    retTo.setRealmId(rule.getRealmId());
                }
            } else if (rule.getCircleVisibilityId1From() != null) {
                retTo.setId("default");
                retTo.setName("Default Circle");
                retTo.setDescription("All users not assigned to any other Circle");
                retTo.setRealmId(rule.getRealmId());
            } else {
                retTo.setId("defaultCircleBetweenMembers");
                retTo.setName("Default Circle");
                retTo.setDescription("All users not assigned to any other Circle");
                retTo.setRealmId(rule.getRealmId());
            }
            customVisbilityRulesModelTo.setId(retTo.getId());
            customVisbilityRulesModelTo.setName(retTo.getName());
            customVisbilityRulesModelTo.setDescription(retTo.getDescription());
            groupsVisibilityRules.setTo(customVisbilityRulesModelTo);
            arrayCircleVisibilityRulesList.add(groupsVisibilityRules);
        });
        OlvidCircleVisibilityRulesListByVisibilityModel ret = new OlvidCircleVisibilityRulesListByVisibilityModel().newOlvidCircleVisibilityRulesListByVisibilityModel(em, session, realmModel, arrayCircleVisibilityRulesList, id, isWithMembers);
        HashMap<String, List<CirclesVisibilityRulesModel>> from = new HashMap<String, List<CirclesVisibilityRulesModel>>();
        if (!ret.getCircleVisibilityRulesListFromSeeContact().isEmpty()) {
            OlvidCircleVisibilityRulesListModel.filterWithVisibility(id, "seeContact", from, ret.getCircleVisibilityRulesListFromSeeContact());
        }
        if (!ret.getCircleVisibilityRulesListFromNoContact().isEmpty()) {
            OlvidCircleVisibilityRulesListModel.filterWithVisibility(id, "noContact", from, ret.getCircleVisibilityRulesListFromNoContact());
        }
        if (!ret.getCircleVisibilityRulesListFromSeeAutoContact().isEmpty()) {
            OlvidCircleVisibilityRulesListModel.filterWithVisibility(id, "seeAutoContact", from, ret.getCircleVisibilityRulesListFromSeeAutoContact());
        }
        if (!ret.getCircleVisibilityRulesListFromSeeNoContact().isEmpty()) {
            OlvidCircleVisibilityRulesListModel.filterWithVisibility(id, "seeNoContact", from, ret.getCircleVisibilityRulesListFromSeeNoContact());
        }
        HashMap<String, List<CirclesVisibilityRulesModel>> to = new HashMap<String, List<CirclesVisibilityRulesModel>>();
        if (!ret.getCircleVisibilityRulesListToSeeContact().isEmpty()) {
            OlvidCircleVisibilityRulesListModel.filterWithVisibility(id, "seeContact", to, ret.getCircleVisibilityRulesListToSeeContact());
        }
        if (!ret.getCircleVisibilityRulesListToNoContact().isEmpty()) {
            OlvidCircleVisibilityRulesListModel.filterWithVisibility(id, "noContact", to, ret.getCircleVisibilityRulesListToNoContact());
        }
        if (!ret.getCircleVisibilityRulesListToSeeAutoContact().isEmpty()) {
            OlvidCircleVisibilityRulesListModel.filterWithVisibility(id, "seeAutoContact", to, ret.getCircleVisibilityRulesListToSeeAutoContact());
        }
        if (!ret.getCircleVisibilityRulesListToSeeNoContact().isEmpty()) {
            OlvidCircleVisibilityRulesListModel.filterWithVisibility(id, "seeNoContact", to, ret.getCircleVisibilityRulesListToSeeNoContact());
        }
        olvidCircleVisibilityRulesListModel.setFrom(from);
        olvidCircleVisibilityRulesListModel.setTo(to);
        olvidCircleVisibilityRulesListModel.setCircleVisibilityRulesList(arrayCircleVisibilityRulesList);
        return olvidCircleVisibilityRulesListModel;
    }

    private static void filterWithVisibility(String id, String visibility, Map<String, List<CirclesVisibilityRulesModel>> from, List<CirclesVisibilityRulesModel> array) {
        if (!id.contentEquals("default")) {
            from.put(visibility, array.stream().filter(circle -> !circle.getFrom().getId().contentEquals(id) || !circle.getTo().getId().contentEquals(id)).collect(Collectors.toList()));
        } else {
            from.put(visibility, array.stream().filter(circle -> !(circle.getFrom().getId().contentEquals(id) && circle.getTo().getId().contentEquals(id) || circle.getFrom().getId().contentEquals("default-from") && circle.getTo().getId().contentEquals("default-to") || circle.getFrom().getId().contentEquals("default-to") && circle.getTo().getId().contentEquals("default-from"))).collect(Collectors.toList()));
        }
    }

    private static void getMembersViewListFormated(OlvidCircleVisibilityRulesListByVisibilityModel ret, List<Map<String, Object>> array1, List<CirclesVisibilityRulesModel> array2, String visibilityRule) {
        array2.forEach(elem -> elem.getFrom().getCircleMembers().forEach(member -> OlvidCircleVisibilityRulesListModel.addCircleMembersOnElem(array1, visibilityRule, elem, member)));
    }

    private static void addCircleMembersOnElem(List<Map<String, Object>> array1, String visibilityRule, CirclesVisibilityRulesModel elem, CustomUserBasicModel member) {
        HashMap<String, Object> objFrom = new HashMap<String, Object>();
        objFrom.put("id", elem.getFrom().getId());
        objFrom.put("name", elem.getFrom().getName());
        objFrom.put("description", elem.getFrom().getDescription());
        objFrom.put("member", member);
        objFrom.put("visibilityRule", elem.getVisibilityRule());
        HashMap<String, Object> objTo = new HashMap<String, Object>();
        objTo.put("id", elem.getTo().getId());
        objTo.put("name", elem.getTo().getName());
        objTo.put("description", elem.getTo().getDescription());
        objTo.put("member", member);
        objTo.put("visibilityRule", visibilityRule);
        HashMap<String, HashMap<String, Object>> objFormated = new HashMap<String, HashMap<String, Object>>();
        objFormated.put("from", objFrom);
        objFormated.put("to", objTo);
        array1.add(objFormated);
    }
}

