/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.classes.models.circleVisibility;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.olvid.keycloak.classes.models.circleVisibility.CircleVisibilityModel;
import io.olvid.keycloak.classes.models.users.CustomUserModel;
import io.olvid.keycloak.jpa.OlvidCircleVisibilityRules;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CirclesVisibilityRulesModel {
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonProperty(value="id")
    public String id;
    @JsonProperty(value="from")
    public CircleVisibilityModel from;
    @JsonProperty(value="to")
    public CircleVisibilityModel to;
    @JsonProperty(value="visibilityRule")
    public String visibilityRule;
    @JsonProperty(value="circleMembers")
    public List<CustomUserModel> circleMembers;

    public CircleVisibilityModel getFrom() {
        return this.from;
    }

    public void setFrom(CircleVisibilityModel from) {
        this.from = from;
    }

    public CircleVisibilityModel getTo() {
        return this.to;
    }

    public void setTo(CircleVisibilityModel to) {
        this.to = to;
    }

    public String getVisibilityRule() {
        return this.visibilityRule;
    }

    public void setVisibilityRule(String visibilityRule) {
        this.visibilityRule = visibilityRule;
    }

    public List<CustomUserModel> getCircleMembers() {
        return this.circleMembers;
    }

    public void setCircleMembers(List<CustomUserModel> circleMembers) {
        this.circleMembers = circleMembers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CirclesVisibilityRulesModel that = (CirclesVisibilityRulesModel)o;
        return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && Objects.equals(this.visibilityRule, that.visibilityRule) && Objects.equals(this.circleMembers, that.circleMembers);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.visibilityRule, this.circleMembers);
    }

    public String toString() {
        return "CirclesVisibilityRulesModel{from=" + String.valueOf(this.from) + ", to=" + String.valueOf(this.to) + ", visibilityRule='" + this.visibilityRule + "', circleMembers=" + String.valueOf(this.circleMembers) + "}";
    }

    public void checkRulesDuplicate(EntityManager em) {
        StringBuilder sb = new StringBuilder("SELECT ocvr.realmId, ocvr.circleVisibilityId1From, count(ocvr.circleVisibilityId1From), ocvr.circleVisibilityId2To, count(circleVisibilityId2To) FROM OlvidCircleVisibilityRules ocvr group by ocvr.realmId, ocvr.circleVisibilityId1From, ocvr.circleVisibilityId2To having count(ocvr.circleVisibilityId1From) > 1 or count(ocvr.circleVisibilityId2To) > 1");
        TypedQuery qPairs = em.createQuery(sb.toString(), Object[].class);
        qPairs.getResultList().forEach(result -> {
            String realmId = result[0] != null ? result[0].toString() : null;
            String circleIdFrom = result[1] != null ? result[1].toString() : null;
            String circleIdTo = result[3] != null ? result[3].toString() : null;
            TypedQuery queryFromTo = em.createNamedQuery("OlvidCircleVisibilityRules.getByIdFromAndTo", OlvidCircleVisibilityRules.class);
            if (circleIdTo == null) {
                queryFromTo = em.createNamedQuery("OlvidCircleVisibilityRules.getByIdFromAndToIsNull", OlvidCircleVisibilityRules.class);
                queryFromTo.setParameter("realmId", (Object)realmId);
                queryFromTo.setParameter("fromId", (Object)circleIdFrom);
            } else if (circleIdFrom == null) {
                queryFromTo = em.createNamedQuery("OlvidCircleVisibilityRules.getByIdFromIsNullAndTo", OlvidCircleVisibilityRules.class);
                queryFromTo.setParameter("realmId", (Object)realmId);
                queryFromTo.setParameter("toId", (Object)circleIdTo);
            } else {
                queryFromTo.setParameter("realmId", (Object)realmId);
                queryFromTo.setParameter("fromId", (Object)circleIdFrom);
                queryFromTo.setParameter("toId", (Object)circleIdTo);
            }
            List olvidCirclesFromTo = queryFromTo.getResultList();
            List visibilities = olvidCirclesFromTo.stream().map(OlvidCircleVisibilityRules::getVisibility).distinct().collect(Collectors.toList());
            int countLinks = 0;
            if (!visibilities.isEmpty()) {
                if (visibilities.size() == 1) {
                    TypedQuery querySelectDuplicateRules = em.createNamedQuery("OlvidCircleVisibilityRules.getByIdFromTo", OlvidCircleVisibilityRules.class);
                    querySelectDuplicateRules.setParameter("realmId", (Object)realmId);
                    querySelectDuplicateRules.setParameter("fromId", (Object)circleIdFrom);
                    querySelectDuplicateRules.setParameter("toId", (Object)circleIdTo);
                    List ids = olvidCirclesFromTo.stream().map(OlvidCircleVisibilityRules::getId).collect(Collectors.toList());
                    ids.remove(ids.size() - 1);
                    countLinks = em.createNamedQuery("OlvidCircleVisibilityRules.deleteCircleRulesWithIds").setParameter("ids", ids).executeUpdate();
                } else {
                    TypedQuery querySelectDuplicateRules = em.createNamedQuery("OlvidCircleVisibilityRules.getByIdFromTo", OlvidCircleVisibilityRules.class);
                    querySelectDuplicateRules.setParameter("realmId", (Object)realmId);
                    querySelectDuplicateRules.setParameter("fromId", (Object)circleIdFrom);
                    querySelectDuplicateRules.setParameter("toId", (Object)circleIdTo);
                    List ids = olvidCirclesFromTo.stream().filter(rule -> !rule.getVisibility().contentEquals("NO")).map(OlvidCircleVisibilityRules::getId).collect(Collectors.toList());
                    if (ids.size() != olvidCirclesFromTo.size()) {
                        countLinks = em.createNamedQuery("OlvidCircleVisibilityRules.deleteCircleRulesWithIds").setParameter("ids", ids).executeUpdate();
                    } else {
                        ids.remove(ids.size() - 1);
                        countLinks = em.createNamedQuery("OlvidCircleVisibilityRules.deleteCircleRulesWithIds").setParameter("ids", ids).executeUpdate();
                    }
                }
            }
        });
    }
}

